/**
* \file: mlink_wl_if.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* MLINK WL Adapter
*
* \component: mlink
*
* \author: Michael Methner ADITG/SW1 mmethner@de.adit-jv.com
*
* \copyright: (c) 2003 - 2013 ADIT Corporation
*
* \history
* 0.1 Michael Methner Initial version
*
***********************************************************************/

#ifndef _MLINK_WL_IF_H_
#define _MLINK_WL_IF_H_

#include <wayland-client.h>
#include <wayland-egl.h>

#include "mlink_wl.h"

typedef struct mlink_wl_if_context mlink_wl_if_context;
typedef struct WlSeat WlSeat;

#define MLINK_WL_IF_FAIL 0
#define MLINK_WL_IF_SUCCESS 1

void
mlink_wl_if_init_global_handler(void* data, struct wl_registry* registry,
    uint32_t name, const char* interface, uint32_t version);


int
mlink_wl_if_init(mlink_wl_context * p_wl_ctx);

void
mlink_wl_if_deinit(mlink_wl_context * p_wl_ctx);


int mlink_wl_if_set_surface_format(mlink_wl_context * p_wl_ctx,
    VNCPixelFormat * p_framebuffer_pixelformat);

int
mlink_wl_if_create_img(mlink_wl_context * p_wl_ctx, int width, int height);


void
mlink_wl_if_destroy_img(mlink_wl_context * p_wl_ctx);

void
mlink_wl_if_draw(mlink_wl_context * p_wl_ctx);

#endif /* _MLINK_WL_IF_H_ */
